require( "scripts/style.lua" );


if (IsMacintoshBuild()) then
	StopMainMenuMusic();
end


UILevelFont = {
  proportionalFont,
  14,
  WhiteColor
};

UINameFont = {
  proportionalFont,
  13,
  BlackColor
};

UpgradeButtonFont = {
  standardFont,
  18,
  BlackColor
};




MultiplayerInfoFont = {
  standardFont,
  40,
  BorderColor
};

MultiplayerInfoSubFont = {
  standardFont,
  20,
  BorderColor
};

UIGoalFont = {
  proportionalFont,
  12,
  BlackColor
};

OpenFont = {
  proportionalFont,
  13,
  BlackColor
};

UIScoreFont = {
  proportionalFont,
  19,
  BlackColor
};


UpgradeButtonGraphics = {
	"ui/hud/ui_single_endless_upgrade-button_up",
	"ui/hud/ui_single_endless_upgrade-button_down",
	"ui/hud/ui_single_endless_upgrade-button_over"
};


Phone1ButtonGraphics = {
	"ui/phone_busser_a",
	"ui/phone_busser_b",
	"ui/phone_busser_b"
};



kPauseStr = 'pause';
if (MultiPlayerGame(false)) then 
	kPauseStr = 'quit';
end

kPlayerHeadWidth = 50;
kPlayerHeadHeight = 50;

kOpenClosedx = 37;
kOpenClosedy = 582;
kOpenClosedw = 67;
kOpenClosedh = 16;



function MakeCareerSingleUI()
	MakeDialog
	{
		Window
		{
			x = 0, y = 0,
			w = kMax, h = kMax,
			name = "uihud",
			

			Bitmap
			{
				x = 0,
				y = 536,
				image = "ui/hud/ui_single_story_base"
			},
			
			Text
			{
				x = kOpenClosedx,
				y = kOpenClosedy,
				w = kOpenClosedw,
				h = kOpenClosedh,
				flags = kHAlignCenter + kVAlignCenter,
				font = OpenFont,
				label = "open",
				name = 'openclosed'
			},

			Window
			{
				x = 159,
				y = 543,
				w = kPlayerHeadWidth,
				h = kPlayerHeadHeight,
				name = "playerhead1"
			},

			AutoFitText
			{
				font = UINameFont,
				name = "playername1",
				x=197,y=577,w=135,h=30,
				flags = kHAlignCenter + kVAlignCenter,
				label = ""
			};
			
			Text
			{
				font = UIGoalFont,
				name = "goal",
				x=356,y=584,w=87,h=16,
				flags = kHAlignCenter + kVAlignCenter,
				label = "goal"
			};
			
			Text
			{
				font = UILevelFont,
				name = "level",
				x=721,y=553,w=71,h=14,
				flags = kHAlignCenter + kVAlignCenter,
				label = "level"
			};
			
			Text
			{
				font = UIScoreFont,
				name = "scoreval1",
				x=228,y=563,w=79,h=20,
				flags = kHAlignRight + kVAlignCenter,
				label = ""
			};
			
			Bitmap
			{
			
				x = 161,
				y = 540,
				image = "ui/hud/ui_single_story_reflections"
			},
		},
	}
end


function MakeEndlessSingleUI()
	MakeDialog
	{
		Window
		{
			x = 0, y = 0,
			w = kMax, h = kMax,
			name = "uihud",

			Bitmap
			{
				x = 0,
				y = 536,
				image = "ui/hud/ui_single_endless_base",
				
				Bitmap
				{
					name = "livesicon_0",
					x = 473,
					y = 17,
					image = "ui/hud/ui_single_endless_life-markers"
				},
				
				Bitmap
				{
					name = "livesicon_1",
					x = 518,
					y = 17,
					image = "ui/hud/ui_single_endless_life-markers"
				},
				
				Bitmap
				{
					name = "livesicon_2",
					x = 563,
					y = 17,
					image = "ui/hud/ui_single_endless_life-markers"
				},
				
				Bitmap
				{
					name = "livesicon_3",
					x = 608,
					y = 17,
					image = "ui/hud/ui_single_endless_life-markers"
				},
				
				Bitmap
				{
					name = "livesicon_4",
					x = 653,
					y = 17,
					image = "ui/hud/ui_single_endless_life-markers"
				},
			},
			
			
			Button
			{
				x=346,
				y=542,
				flash = 1,
				disablerollover = 1,
				graphics = UpgradeButtonGraphics,
				name="upgrade",
				font=UpgradeButtonFont,
				label="upgrades",
				xoffset = 0,
				type = kPush,
				command=
					function()
						PauseGame(true);
						DoModal("scripts/upgrade.lua");
					end
			},
			
			Window
			{
				x = 159,
				y = 543,
				w = kPlayerHeadWidth,
				h = kPlayerHeadHeight,
				name = "playerhead1"
			},
			
			AutoFitText
			{
				font = UINameFont,
				name = "playername1",
				x=197,y=577,w=135,h=30,
				flags = kHAlignCenter + kVAlignCenter,
				label = ""
			};
			
			
			Text
			{
				font = UIGoalFont,
				name = "goal",
				x=356,y=584,w=87,h=16,
				flags = kHAlignCenter + kVAlignCenter,
				label = "goal"
			};
			
			Text
			{
				font = UIScoreFont,
				name = "scoreval1",
				x=228,y=563,w=79,h=20,
				flags = kHAlignRight + kVAlignCenter,
				label = ""
			};
			
			Bitmap
			{
				x = 161,
				y = 540,
				image = "ui/hud/ui_single_endless_reflections"
			},
		},
	}
end

function MakeMultiplayerShiftUI() 
	MakeDialog 
	{
		Window
		{
			x = 0, y = 0,
			w = kMax, h = kMax,
			name = "uihud",
			
		
			Bitmap
			{
				x = 0,
				y = 536,
				image = "ui/hud/ui_multi-compete_base"
			},
			
			Text
			{
				x = kOpenClosedx,
				y = kOpenClosedy,
				w = kOpenClosedw,
				h = kOpenClosedh,
				font = OpenFont,
				flags = kHAlignCenter + kVAlignCenter,
				label = "open",
				name = 'openclosed'
			},
			
			Bitmap
			{
				x=159,
				y=543,
				name='player1base',
				image='ui/hud/avatar-base_purple',
				
				Window
				{
					x = 0,
					y = 0,
					w = kMax,
					h = kMax,
					name = "playerhead1"
				},
			},
			
			Bitmap
			{
				x=591,
				y=543,
				name='player2base',
				image='ui/hud/avatar-base_turqoise',
				
				Window
				{
					x = 0,
					y = 0,
					w = kMax,
					h = kMax,
					name = "playerhead2"
				},
			},
			
			Bitmap
			{
				x=214,
				y=558,
				name='player1scorebase',
				image='ui/hud/score-base_purple',
				
				Text
				{
					font = UIScoreFont,
					name = "scoreval1",
					x=0,y=0,w=kMax-15,h=kMax,
					flags = kHAlignRight + kVAlignCenter,
					label = ""
				};
			},
			
			Bitmap
			{
				x=477,
				y=558,
				name='player2scorebase',
				image='ui/hud/score-base_turqoise',
				
				Text
				{
					font = UIScoreFont,
					name = "scoreval2",
					x=15,y=0,w=kMax,h=kMax,
					flags = kHAlignLeft + kVAlignCenter,
					label = ""
				};
			},
			
			Bitmap
			{
				x=349,
				y=545,
				name='player1meterbase',
				image='ui/hud/score-battle-meter_purple'
			},
			
			Bitmap
			{
				x=400,
				y=545,
				name='player2meterbase',
				image='ui/hud/score-battle-meter_turqoise'
			},
			
			
			AutoFitText
			{
				font = UINameFont,
				name = "playername1",
				x=197,y=577,w=135,h=30,
				flags = kHAlignCenter + kVAlignCenter,
				label = ""
			};
			
			AutoFitText
			{
				font = UINameFont,
				name = "playername2",
				x=465,y=577,w=135,h=30,
				flags = kHAlignCenter + kVAlignCenter,
				label = ""
			};
			
			Text
			{
				font = UILevelFont,
				name = "level",
				x=721,y=553,w=71,h=14,
				flags = kHAlignCenter + kVAlignCenter,
				label = "level"
			};			
			
			Bitmap
			{
				x = 161,
				y = 540,
				image = "ui/hud/ui_multi-compete_reflections"
			},
		},
	}
end

function MakeMultiplayerEndlessUI() 
	MakeDialog 
	{
		Window
		{
			x = 0, y = 0,
			w = kMax, h = kMax,
			name = "uihud",
			
		
			Bitmap
			{
				x = 0,
				y = 536,
				image = "ui/hud/ui_multi-endless_base",
				
				Bitmap
				{
					name = "livesicon_0",
					x = 290,
					y = 12,
					image = "ui/hud/ui_multi-endless_life-markers"
				},
				
				Bitmap
				{
					name = "livesicon_1",
					x = 340,
					y = 10,
					image = "ui/hud/ui_multi-endless_life-markers"
				},
				
				Bitmap
				{
					name = "livesicon_2",
					x = 390,
					y = 7,
					image = "ui/hud/ui_multi-endless_life-markers"
				},
				
				Bitmap
				{
					name = "livesicon_3",
					x = 440,
					y = 10,
					image = "ui/hud/ui_multi-endless_life-markers"
				},
				
				Bitmap
				{
					name = "livesicon_4",
					x = 490,
					y = 12,
					image = "ui/hud/ui_multi-endless_life-markers"
				},
			},
			
			Bitmap
			{
				x=159,
				y=543,
				name='player1base',
				image='ui/hud/avatar-base_purple',
				
				Window
				{
					x = 0,
					y = 0,
					w = kMax,
					h = kMax,
					name = "playerhead1"
				},
			},
			
			Bitmap
			{
				x=591,
				y=543,
				name='player2base',
				image='ui/hud/avatar-base_turqoise',
				
				Window
				{
					x = 0,
					y = 0,
					w = kMax,
					h = kMax,
					name = "playerhead2"
				},
			},
			
			
			AutoFitText
			{
				font = UINameFont,
				name = "playername1",
				x=197,y=577,w=135,h=30,
				flags = kHAlignCenter + kVAlignCenter,
				label = ""
			};
			
			AutoFitText
			{
				font = UINameFont,
				name = "playername2",
				x=465,y=577,w=135,h=30,
				flags = kHAlignCenter + kVAlignCenter,
				label = ""
				
			};
			
			Text
			{
				font = UIScoreFont,
				name = "scoreval1",
				x=357,y=576,w=89,h=21,
				flags = kHAlignRight + kVAlignCenter,
				label = ""
			};
		},
	}
end

function MakeGameUI()
	return Group {
		GameUI
		{
			x = 0,
			y = 0,
			w = kMax,
			h = kMax,
			name = "gameui",
			needlex = 397,
			needley = 553,
			needlecenterx = 400,
			needlecentery = 675,
			needlerange = 19,
			needlespeed = 4,
			meterx = 346,
			metery = 539,
			meterstartdeg = 50,
			meterenddeg = 1,
			meterspeed = 7,
			endlessmeterx = 346,
			endlessmetery = 540,
			endlessmeterstartdeg = 49,
			endlessmeterenddeg = 3,
			endlessmeterspeed = 7,
			mpfullmeter = 2000,
			
		},
	}
end




MakeDialog
{
		GameWindow
		{ 
			name="maingamewindow",
			x=0,
			y=0,
			w=800,
			h=600,
			fit = false,

			

			
			
			
			GameUILayer
			{
				x=0,
				y=0,
				w=kMax,
				h=kMax,
				name = "UILevel"
			},
			
			
			MakeGameUI();
			
			
			GamePostUILayer
			{
				x=0,
				y=0,
				w=kMax,
				h=kMax,
				name = "PostUILevel"
			},
			
			SetStyle(SolidButtonStyle);
			
			Button
			{
				x=700,
				y=570,
				name="pause",
				label=kPauseStr,
				command=
					function()
						if (MultiPlayerGame(false)==true) then
							EnableWindow("mppause", true);
							SetFade(kDisableFade);
						else
							PauseGame(true);
							DoModal("scripts/pause.lua");
						end
					end
			},
			
			Button
			{
				x=650,
				y=500,
				name="skiptutorial",
				label="skiptutorial",
				command=
					function()
						PauseGame(true);
						result = DisplayDialog { 
							"scripts/yesno.lua", 
							body ="tutorialconfirm",
							title = "" 
						};
						if (result=='yes') then
							DoSkipTutorial();
						end
						PauseGame(false);
					end
			},
			SetStyle(DefaultStyle);

			
			Bitmap
			{
				name="multiplayerinfo",
				image="backgrounds/popup",
				x=kCenter,
				y=kCenter,
				
				Text
				{
					font = MultiplayerInfoFont,
					name = "multiplayerinfotext",
					x=20,y=kPopupDialogTopY,w=kMax-20,h=kPopupDialogH,
					flags = kHAlignCenter + kVAlignCenter,
					label = "connectingtoopponent"
				};
				
				Text
				{
					font = MultiplayerInfoSubFont,
					name = "multiplayerinfosubtext",
					x=20,y=115,w=kMax-20,h=kMax,
					flags = kHAlignCenter + kVAlignCenter,
					label = ""
				};
			},
			
			ScreenFade
			{
				x=0,
				y=0,
				w=kMax,
				h=kMax,
				name="screenfade"
			},
			
			MouseShield
			{
				x = 0, y = 0,
				w = kMax, h = kMax,
				name = "mppause",
				
				Bitmap
				{
					image="backgrounds/popup",
					x=kCenter,
					y=kCenter,
			        
					SetStyle(StandardButtonStyle);
					Button
					{
						command=
							function()
								QuitGame(true);
								CloseAllWindows();
							end;
						label = 'yes',
						x = 35,
						y = 165,
					},
					Button
					{
						command=
							function() 
								EnableWindow("mppause", false);
								SetFade(0);
							end;
						label = 'no',
						x = 235,
						y = 165,
					},
					SetStyle(DefaultStyle);
			        
					
					Text
					{
						font = OKBodyFont,
						x=20,y=kPopupDialogTopY,
						w=kMax-40,h=195-kPopupDialogTopY,
						flags = kVAlignCenter + kHAlignCenter,
						label= 'quitconfirm',
					};
				},
			};
			
			
						Bitmap
			{
				x = 700,
				y = 250,
				name = "phonebox2",
				image = "ui/icon_backdrop_a",
				
				Button
				{
					x=kCenter,
					y=7,
					graphics = Phone1ButtonGraphics,
					name="phone1",
					type = kPush,
					xoffset = 0,
					command=
						function()
							PhoneButton(0);
						end
				},
				
				Button
				{
					x=kCenter,
					y=70,
					graphics = Phone1ButtonGraphics,
					name="phone2",
					type = kPush,
					xoffset = 0,
					command=
						function()
							PhoneButton(1);
						end
				},
			},
			
			Bitmap
			{
				x = 700,
				y = 180,
				name = "phonebox3",
				image = "ui/icon_backdrop_b",
				
				Button
				{
					x=kCenter,
					y=7,
					graphics = Phone1ButtonGraphics,
					name="phone1",
					type = kPush,
					xoffset = 0,
					command=
						function()
							PhoneButton(0);
						end
				},
				
				Button
				{
					x=kCenter,
					y=70,
					graphics = Phone1ButtonGraphics,
					name="phone2",
					type = kPush,
					xoffset = 0,
					command=
						function()
							PhoneButton(1);
						end
				},
				
				Button
				{
					x=kCenter,
					y=133,
					graphics = Phone1ButtonGraphics,
					name="phone3",
					type = kPush,
					xoffset = 0,
					command=
						function()
							PhoneButton(2);
						end
				},
			},
			
			Bitmap
			{
				x = 700,
				y = 120,
				name = "phonebox4",
				image = "ui/icon_backdrop_c",
				
				Button
				{
					x=kCenter,
					y=7,
					graphics = Phone1ButtonGraphics,
					name="phone1",
					type = kPush,
					xoffset = 0,
					command=
						function()
							PhoneButton(0);
						end
				},
				
				Button
				{
					x=kCenter,
					y=70,
					graphics = Phone1ButtonGraphics,
					name="phone2",
					type = kPush,
					xoffset = 0,
					command=
						function()
							PhoneButton(1);
						end
				},
				
				Button
				{
					x=kCenter,
					y=133,
					graphics = Phone1ButtonGraphics,
					name="phone3",
					type = kPush,
					xoffset = 0,
					command=
						function()
							PhoneButton(2);
						end
				},
				
				Button
				{
					x=kCenter,
					y=196,
					graphics = Phone1ButtonGraphics,
					name="phone4",
					type = kPush,
					xoffset = 0,
					command=
						function()
							PhoneButton(3);
						end
				},
			},
			
			
		},
	
}
StopMainMenuMusic();
EnableWindow("mppause", false);
AdoptChatWindow();